﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;

public partial class TefscLaboratoryRequestReport : BasePage
{
    private readonly List<ReportParameter> _reportParameters;

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabOrder.aspx",
        "/PatientWorkflows.aspx"
    };

    public TefscLaboratoryRequestReport()
    {
        _reportParameters = new List<ReportParameter>();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
            Response.Redirect("ErrorPage.aspx?id=100");

        ReportViewerTefscLaboratoryRequest.Reset();
        SetReportPath();
        SetReportParameters();
        ReportViewerTefscLaboratoryRequest.ProcessingMode = ProcessingMode.Remote;
        ReportViewerTefscLaboratoryRequest.Visible = true;
        ReportViewerTefscLaboratoryRequest.ServerReport.Refresh();

        if (!Page.IsPostBack)
            SetReferringPage();
    }

    private void SetReportPath()
    {
        var config = RegistriesConfigurations.GetConfig();

        ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath = "TefscLaboratoryRequestReport";
        ReportViewerTefscLaboratoryRequest.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewerTefscLaboratoryRequest.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);

        if (ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
         //         config.BaseReportPath, 0) == -1)                    
        {
            ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath =
               Helpers.GetConfigEntry("BaseReportPath") + ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath;
        //          config.BaseReportPath + ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath; 
        }
    }

    private void SetReportParameters()
    {
        _reportParameters.Clear();
        SetActivityId();
        ReportViewerTefscLaboratoryRequest.ServerReport.SetParameters(_reportParameters);
    }

    private void SetActivityId()
    {
        ReportParameter reportParamSetActivityId = 
            new ReportParameter("activityId", Request.QueryString["activityId"]);
        _reportParameters.Add(reportParamSetActivityId);
    }

    private bool AccessAllowed()
    {
        //_currentUser = (UserAccountManager)HttpContext.Current.User;
        //return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17));
        return true;
    }

    protected void Cancel_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "Lab Orders";
    }

    public override string AppObjectCode()
    {
        return "TEFSC_LABORATORY_REQUEST_REPORT";
    }

}
